/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat.mods;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.addy4ever.nivarion.network.PacketHandler;
import net.addy4ever.nivarion.network.packets.mod.ModListPacket;
import net.addy4ever.nivarion.network.packets.mod.RespondModListPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class ModCheck {
    private static final List<UUID> IN_LIST = new ArrayList<UUID>();
    private static final List<String> CACHE = new ArrayList<String>();
    private static final List<String> CACHE_RAW = new ArrayList<String>();

    public static void remove(UUID uuid) {
        IN_LIST.remove(uuid);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        PacketHandler.sendToServer(new ModListPacket(CACHE, CACHE_RAW));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        UUID uuid = event.getEntity().m_20148_();
        MinecraftServer minecraftServer = event.getEntity().m_20194_();
        IN_LIST.add(uuid);
        executorService.schedule(() -> {
            if (IN_LIST.contains(uuid)) {
                ServerPlayer serverPlayer = minecraftServer.m_6846_().m_11259_(uuid);
                if (serverPlayer != null) {
                    RespondModListPacket respondModListPacket = new RespondModListPacket(false);
                    PacketHandler.sendToClient(respondModListPacket, serverPlayer);
                    serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"No mods received."));
                }
                IN_LIST.remove(uuid);
            }
        }, 3L, TimeUnit.SECONDS);
    }

    public static void collectFiles() {
        CACHE.clear();
        CACHE_RAW.clear();
        CACHE_RAW.add("Mods vom Dateisystem: ");
        File file = new File("./mods");
        if (file.exists() && file.isDirectory()) {
            try {
                for (File listFile : file.listFiles()) {
                    if (!listFile.isFile()) continue;
                    HashCode hashCode = Files.asByteSource((File)listFile).hash(Hashing.md5());
                    CACHE.add(hashCode.toString());
                    CACHE_RAW.add(String.valueOf(hashCode) + "\t" + listFile.getName());
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void appendLoadedModsToCacheRaw() {
        CACHE_RAW.add("");
        CACHE_RAW.add(ModList.get().size() + " Mods geladen: ");
        ModList.get().getMods().forEach(iModInfo -> {
            CACHE_RAW.add(iModInfo.getModId());
            CACHE_RAW.add("\t\t" + iModInfo.getDisplayName());
            CACHE_RAW.add("\t\t" + iModInfo.getDescription());
        });
    }
}

