/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat.client.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import net.addy4ever.nivarion.anticheat.client.AntiCheatPacket;

public class OnlinePlayerMessagePacket
extends AntiCheatPacket {
    private MessageType messageType;
    private String playerName;
    private String toPlayer;
    private String message;

    public OnlinePlayerMessagePacket(MessageType messageType, String playerName, String toPlayer, String message) {
        super(2);
        this.messageType = messageType;
        this.playerName = playerName;
        this.toPlayer = toPlayer;
        this.message = message;
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        byteBuf.writeInt(this.messageType.ordinal());
        byteBuf.writeInt(this.playerName.length());
        byteBuf.writeCharSequence((CharSequence)this.playerName, StandardCharsets.UTF_8);
        if (this.messageType == MessageType.PRIVATE) {
            byteBuf.writeInt(this.toPlayer.length());
            byteBuf.writeCharSequence((CharSequence)this.playerName, StandardCharsets.UTF_8);
        }
        byteBuf.writeInt(this.message.length());
        byteBuf.writeCharSequence((CharSequence)this.message, StandardCharsets.UTF_8);
    }

    @Override
    public void decode(ByteBuf byteBuf) {
        this.messageType = MessageType.values()[byteBuf.readInt()];
        this.playerName = byteBuf.readCharSequence(byteBuf.readInt(), StandardCharsets.UTF_8).toString();
        this.toPlayer = this.messageType == MessageType.PRIVATE ? byteBuf.readCharSequence(byteBuf.readInt(), StandardCharsets.UTF_8).toString() : null;
        this.message = byteBuf.readCharSequence(byteBuf.readInt(), StandardCharsets.UTF_8).toString();
    }

    @Override
    public void handle(Channel channel) {
    }

    public static enum MessageType {
        PRIVATE,
        PUBLIC;

    }
}

