/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.addy4ever.nivarion.Nivarion;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class XRay {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final long CHECK_INTERVAL_MS = 10000L;
    private long lastCheckTime = 0L;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long currentTime;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && (currentTime = System.currentTimeMillis()) - this.lastCheckTime >= 10000L) {
                this.checkXRayModels();
                this.lastCheckTime = currentTime;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        this.lastCheckTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.lastCheckTime = 0L;
    }

    private List<String> getActiveResourcePackNames() {
        ArrayList<String> packNames = new ArrayList<String>();
        Minecraft mc = Minecraft.m_91087_();
        PackRepository packRepository = mc.m_91099_();
        for (Pack pack : packRepository.m_10524_()) {
            packNames.add(pack.m_10429_().getString());
        }
        return packNames;
    }

    private void checkXRayModels() {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager resourceManager = mc.m_91098_();
        HashSet<ResourceLocation> blocksToCheck = new HashSet<ResourceLocation>();
        blocksToCheck.add(ResourceLocation.m_135820_((String)"minecraft:dirt"));
        blocksToCheck.add(ResourceLocation.m_135820_((String)"minecraft:stone"));
        blocksToCheck.add(ResourceLocation.m_135820_((String)"minecraft:netherrack"));
        blocksToCheck.add(ResourceLocation.m_135820_((String)"minecraft:end_stone"));
        boolean potentialXRayFound = false;
        for (ResourceLocation blockId : blocksToCheck) {
            try {
                Set<ResourceLocation> effectiveModelIds = this.getEffectiveModelsFromBlockstate(resourceManager, blockId, new HashSet<ResourceLocation>());
                if (effectiveModelIds.isEmpty()) continue;
                for (ResourceLocation effectiveModelId : effectiveModelIds) {
                    if (this.isXRayModelRecursive(resourceManager, effectiveModelId, new HashSet<ResourceLocation>())) {
                        potentialXRayFound = true;
                    } else {
                        ResourceLocation textureLoc = this.getTextureLocationFromModel(resourceManager, effectiveModelId, new HashSet<ResourceLocation>());
                        if (textureLoc != null && this.isTextureTransparent(resourceManager, textureLoc)) {
                            potentialXRayFound = true;
                        }
                    }
                    if (!potentialXRayFound) continue;
                    break;
                }
            }
            catch (Exception effectiveModelIds) {
                // empty catch block
            }
            if (!potentialXRayFound) continue;
            break;
        }
        if (potentialXRayFound) {
            mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)"\u00a7cWARNING: Potentially malicious resource pack detected!"));
            StringBuilder tpNames = new StringBuilder();
            List<String> tpNamesUnformatted = this.getActiveResourcePackNames();
            for (int i = 0; i < tpNamesUnformatted.size(); ++i) {
                tpNames.append(tpNamesUnformatted.get(i));
                if (i + 1 >= tpNamesUnformatted.size()) continue;
                tpNames.append(", ");
            }
            ArrayList<String> messages = new ArrayList<String>(4);
            messages.add("X-Ray Texturepack entdeckt.");
            if (mc.f_91074_ != null) {
                messages.add("Spieler: " + mc.f_91074_.m_7755_().getString());
            }
            messages.add("Zeitpunkt: " + new SimpleDateFormat("HH:mm:ss dd.MM.yyyy").format(new Date()));
            messages.add("Geladene Texturepacks: " + String.valueOf(tpNames));
            StringBuilder stringBuilder = new StringBuilder();
            tpNamesUnformatted.forEach(str -> stringBuilder.append((String)str).append(", "));
            Nivarion.triggerAntiCheat(messages, 0, "Namen der Texturepacks: " + String.valueOf(stringBuilder), tpNamesUnformatted);
        }
    }

    private Set<ResourceLocation> getEffectiveModelsFromBlockstate(ResourceManager resourceManager, ResourceLocation blockId, Set<ResourceLocation> visitedBlockstates) throws IOException {
        HashSet<ResourceLocation> modelLocations = new HashSet<ResourceLocation>();
        ResourceLocation blockstatePath = ResourceLocation.m_214293_((String)blockId.m_135827_(), (String)("blockstates/" + blockId.m_135815_() + ".json"));
        if (blockstatePath == null) {
            return modelLocations;
        }
        if (!visitedBlockstates.add(blockstatePath)) {
            return modelLocations;
        }
        try (InputStream inputStream = ((Resource)resourceManager.m_213713_(blockstatePath).orElseThrow(() -> new RuntimeException("Blockstate not found: " + String.valueOf(blockstatePath)))).m_215507_();){
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            JsonObject blockstateJson = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (blockstateJson.has("variants")) {
                JsonObject variants = blockstateJson.getAsJsonObject("variants");
                for (String variantKey : variants.keySet()) {
                    JsonArray modelsArray;
                    JsonElement variantElement = variants.get(variantKey);
                    if (variantElement.isJsonObject()) {
                        modelsArray = new JsonArray();
                        modelsArray.add((JsonElement)variantElement.getAsJsonObject());
                    } else {
                        if (!variantElement.isJsonArray()) continue;
                        modelsArray = variantElement.getAsJsonArray();
                    }
                    for (JsonElement modelEntry : modelsArray) {
                        if (!modelEntry.isJsonObject() || !modelEntry.getAsJsonObject().has("model")) continue;
                        String modelPathString = modelEntry.getAsJsonObject().get("model").getAsString();
                        ResourceLocation modelRef = ResourceLocation.m_135820_((String)modelPathString);
                        modelLocations.add(modelRef);
                    }
                }
            }
        }
        catch (Exception e) {
            modelLocations.add(ResourceLocation.m_214293_((String)blockId.m_135827_(), (String)("block/" + blockId.m_135815_())));
        }
        return modelLocations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isXRayModelRecursive(ResourceManager resourceManager, ResourceLocation modelId, Set<ResourceLocation> visitedModels) {
        ResourceLocation modelPath = ResourceLocation.m_214293_((String)modelId.m_135827_(), (String)("models/" + modelId.m_135815_() + ".json"));
        if (modelPath == null) return false;
        if (!visitedModels.add(modelPath)) {
            return false;
        }
        try (InputStream inputStream = ((Resource)resourceManager.m_213713_(modelPath).orElseThrow(() -> new RuntimeException("Model not found: " + String.valueOf(modelPath)))).m_215507_();){
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            JsonObject modelJson = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            ArrayList<JsonObject> currentModelElements = new ArrayList<JsonObject>();
            if (modelJson.has("elements") && modelJson.get("elements").isJsonArray()) {
                for (JsonElement elementJson : modelJson.getAsJsonArray("elements")) {
                    if (!elementJson.isJsonObject()) continue;
                    currentModelElements.add(elementJson.getAsJsonObject());
                }
            }
            if (modelJson.has("parent")) {
                String parentPath = modelJson.get("parent").getAsString();
                ResourceLocation parentModelId = ResourceLocation.m_135820_((String)parentPath);
                if (parentModelId != null) {
                    boolean parentHasGaps = this.isXRayModelRecursive(resourceManager, parentModelId, visitedModels);
                    if (parentHasGaps && currentModelElements.isEmpty()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (parentHasGaps) {
                        boolean bl = this.hasGapsInElements(currentModelElements, modelPath);
                        return bl;
                    }
                }
            } else if (currentModelElements.isEmpty()) {
                boolean bl = !modelId.equals((Object)ResourceLocation.m_135820_((String)"minecraft:block/block"));
                return bl;
            }
            if (currentModelElements.isEmpty() && modelJson.has("parent")) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.hasGapsInElements(currentModelElements, modelPath);
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasGapsInElements(List<JsonObject> elements, ResourceLocation modelId) {
        if (elements.isEmpty()) {
            return true;
        }
        boolean[][][] occupiedVoxels = new boolean[16][16][16];
        for (JsonObject elementObj : elements) {
            if (!elementObj.has("from") || !elementObj.has("to")) continue;
            JsonElement fromElement = elementObj.get("from");
            JsonElement toElement = elementObj.get("to");
            if (!fromElement.isJsonArray() || !toElement.isJsonArray()) continue;
            int fromX = Math.round(fromElement.getAsJsonArray().get(0).getAsFloat());
            int fromY = Math.round(fromElement.getAsJsonArray().get(1).getAsFloat());
            int fromZ = Math.round(fromElement.getAsJsonArray().get(2).getAsFloat());
            int toX = Math.round(toElement.getAsJsonArray().get(0).getAsFloat());
            int toY = Math.round(toElement.getAsJsonArray().get(1).getAsFloat());
            int toZ = Math.round(toElement.getAsJsonArray().get(2).getAsFloat());
            fromX = Math.max(0, Math.min(16, fromX));
            fromY = Math.max(0, Math.min(16, fromY));
            fromZ = Math.max(0, Math.min(16, fromZ));
            toX = Math.max(0, Math.min(16, toX));
            toY = Math.max(0, Math.min(16, toY));
            toZ = Math.max(0, Math.min(16, toZ));
            for (int x = fromX; x < toX; ++x) {
                for (int y = fromY; y < toY; ++y) {
                    for (int z = fromZ; z < toZ; ++z) {
                        occupiedVoxels[x][y][z] = true;
                    }
                }
            }
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (occupiedVoxels[x][y][z]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceLocation getTextureLocationFromModel(ResourceManager resourceManager, ResourceLocation modelId, Set<ResourceLocation> visitedModels) {
        ResourceLocation modelPath = ResourceLocation.m_214293_((String)modelId.m_135827_(), (String)("models/" + modelId.m_135815_() + ".json"));
        if (modelPath == null) return null;
        if (!visitedModels.add(modelPath)) {
            return null;
        }
        try (InputStream inputStream = ((Resource)resourceManager.m_213713_(modelPath).orElseThrow(() -> new RuntimeException("Model not found: " + String.valueOf(modelPath)))).m_215507_();){
            String parentPath;
            ResourceLocation parentModelId;
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            JsonObject modelJson = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (modelJson.has("textures") && modelJson.get("textures").isJsonObject()) {
                String textureRef;
                ResourceLocation resolvedLoc;
                JsonObject textures = modelJson.getAsJsonObject("textures");
                if (textures.has("all") && (resolvedLoc = this.resolveTextureReference(textureRef = textures.get("all").getAsString(), modelJson, resourceManager, visitedModels)) != null) {
                    ResourceLocation resourceLocation = resolvedLoc;
                    return resourceLocation;
                }
                if (textures.has("particle") && (resolvedLoc = this.resolveTextureReference(textureRef = textures.get("particle").getAsString(), modelJson, resourceManager, visitedModels)) != null) {
                    ResourceLocation resourceLocation = resolvedLoc;
                    return resourceLocation;
                }
            }
            if (modelJson.has("parent") && (parentModelId = ResourceLocation.m_135820_((String)(parentPath = modelJson.get("parent").getAsString()))) != null) {
                ResourceLocation resourceLocation = this.getTextureLocationFromModel(resourceManager, parentModelId, visitedModels);
                return resourceLocation;
            }
            ResourceLocation resourceLocation = null;
            return resourceLocation;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ResourceLocation resolveTextureReference(String textureRef, JsonObject modelJson, ResourceManager resourceManager, Set<ResourceLocation> visitedModels) {
        if (textureRef.startsWith("#")) {
            String parentPath;
            ResourceLocation parentModelId;
            String variableName = textureRef.substring(1);
            if (modelJson.has("textures") && modelJson.getAsJsonObject("textures").has(variableName)) {
                String resolvedPath = modelJson.getAsJsonObject("textures").get(variableName).getAsString();
                if (resolvedPath.startsWith("#")) {
                    return this.resolveTextureReference(resolvedPath, modelJson, resourceManager, visitedModels);
                }
                ResourceLocation baseLoc = ResourceLocation.m_135820_((String)resolvedPath);
                if (baseLoc != null) {
                    return ResourceLocation.m_214293_((String)baseLoc.m_135827_(), (String)("textures/" + baseLoc.m_135815_() + ".png"));
                }
            }
            if (modelJson.has("parent") && (parentModelId = ResourceLocation.m_135820_((String)(parentPath = modelJson.get("parent").getAsString()))) != null) {
                return this.getTextureLocationFromModel(resourceManager, parentModelId, visitedModels);
            }
            return null;
        }
        ResourceLocation baseLoc = ResourceLocation.m_135820_((String)textureRef);
        if (baseLoc != null) {
            return ResourceLocation.m_214293_((String)baseLoc.m_135827_(), (String)("textures/" + baseLoc.m_135815_() + ".png"));
        }
        return null;
    }

    private boolean isTextureTransparent(ResourceManager resourceManager, ResourceLocation textureLocation) {
        boolean bl;
        block10: {
            InputStream inputStream = ((Resource)resourceManager.m_213713_(textureLocation).orElseThrow(() -> new RuntimeException("Texture not found: " + String.valueOf(textureLocation)))).m_215507_();
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
                int transparentPixelCount = 0;
                long totalPixels = (long)image.m_84982_() * (long)image.m_85084_();
                double transparencyRatioThreshold = 1.0E-6;
                for (int y = 0; y < image.m_85084_(); ++y) {
                    for (int x = 0; x < image.m_84982_(); ++x) {
                        int pixel = image.m_84985_(x, y);
                        int alpha = pixel >> 24 & 0xFF;
                        if (alpha >= 255) continue;
                        ++transparentPixelCount;
                    }
                }
                image.close();
                boolean bl2 = bl = (double)transparentPixelCount / (double)totalPixels > transparencyRatioThreshold;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }
}

